/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package zold.proc.parsing;

import data.base.connectors.DBPediaDatabase;
import data.base.Database;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
/**
 *
 * @author claitang1
 */
public class _YagoParser {
    
    private Database theDB;
    private final File myFile;
    private DBPediaDatabase dbp;

    public _YagoParser(Database db, File file){
        theDB = db;
        myFile = file;
        dbp = new DBPediaDatabase(theDB);
    }

    public void parseFile() throws FileNotFoundException {
        processLineByLine();
        log("Done.");
    }

    public final void processLineByLine() throws FileNotFoundException {
        Scanner scanner = new Scanner(myFile);
        try {
          while ( scanner.hasNextLine() ){
            processLine( scanner.nextLine() );
          }
        }
        finally {
          scanner.close();
        }
    }
    protected void processLine(String aLine){
        //use a second Scanner to parse the content of each line
        Scanner scanner = new Scanner(aLine);
        scanner.useDelimiter(" ");
        if ( scanner.hasNext() ){
          String yago = scanner.next();
          scanner.next();
          String dbpedia = scanner.next();
          if(!yago.isEmpty() && !dbpedia.isEmpty()){
            //dbp.insertRessource(yago, dbpedia);
          }
        }
        else {
          System.out.println("Empty or invalid line. Unable to process.");
        }
        scanner.close();
    }

    private static void log(Object aObject){
        System.out.println(String.valueOf(aObject));
    }
}
